<div class="row">
    <div class="col-md-6">
        <h3><b>Case Details</b></h3>
        <div class="form-group">
            <label>Customer Name:</label>
            <label><?php echo e($case['customerDetails']->name, false); ?></label>
        </div>
        <div class="form-group">
            <label>Attorney Name:</label>
            <?php if(isset($case['customerDetails'])): ?>
                <label><?php echo e($case['customerDetails']->name, false); ?></label>
            <?php endif; ?>
        </div>
        <div class="form-group">
            <label>Case Type:</label>
            <label><?php echo e(\Illuminate\Support\Facades\Config::get('constants.cases_type.' . $case->case_type), false); ?></label>
        </div>
        <?php if(isset($case->case_type)): ?>
            <div class="form-group">
                <label>Case Status:</label>
                <label><?php echo e(\Illuminate\Support\Facades\Config::get('constants.case_status.' . $case->case_type), false); ?></label>
            </div>
        <?php endif; ?>
        <div class="form-group">
            <label>Case Progress:</label>
            <label><?php echo e($case->status, false); ?></label>
        </div>
        <?php if(isset($case->court_name)): ?>
            <div class="form-group">
                <label>Court Name:</label>
                <label><?php echo e($case->court_name, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->title)): ?>
            <div class="form-group">
                <label>Case Title:</label>
                <label><?php echo e($case->title, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->judge_name)): ?>
            <div class="form-group">
                <label>Judge Name:</label>
                <label><?php echo e($case->judge_name, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->city)): ?>
            <div class="form-group">
                <label>City: </label>
                <label><?php echo e($case->city, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->case_no)): ?>
            <div class="form-group">
                <label>Case No.: </label>
                <label><?php echo e($case->case_no, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->last_date_hearing)): ?>
            <div class="form-group">
                <label>Last date of Hearing:</label>
                <label><?php echo e($case->last_date_hearing, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->next_hearing_date)): ?>
            <div class="form-group">
                <label>Next date of Hearing:</label>
                <label><?php echo e($case->next_hearing_date, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->year)): ?>
            <div class="form-group">
                <label>Year:</label>
                <label><?php echo e($case->year, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->decision_date)): ?>
            <div class="form-group">
                <label>Decision date:</label>
                <label><?php echo e($case->decision_date, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->required_document)): ?>
            <div class="form-group">
                <label>Required Documents:</label>
                <label><?php echo e($case->required_document, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->from_which_side_we_are)): ?>
            <div class="form-group">
                <label>From which side we are:</label>
                <label><?php echo e($case->from_which_side_we_are, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->set_of_copies_required)): ?>
            <div class="form-group">
                <label>Set of copies required:</label>
                <label><?php echo e($case->set_of_copies_required, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->kuliya_no)): ?>
            <div class="form-group">
                <label>Kuliya No.:</label>
                <label><?php echo e($case->kuliya_no, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->parties_name)): ?>
            <div class="form-group">
                <label>Parties Name:</label>
                <label><?php echo e($case->parties_name, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->news_paper_name)): ?>
            <div class="form-group">
                <label>News Paper Name:</label>
                <label><?php echo e($case->news_paper_name, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->comment_for_attorney)): ?>
            <div class="form-group">
                <label>Comment for Attorney:</label>
                <label><?php echo e($case->comment_for_attorney, false); ?></label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->amountReceived)): ?>
            <div class="form-group">
                <label>Amount Received by Admin:</label>
                <label><?php echo e($case->amountReceived, false); ?> Rs.</label>
            </div>
        <?php endif; ?>
        <?php if(isset($case->amountReceived)): ?>
            <div class="form-group">
                <label>Attorney will get after case completion:</label>
                <label><?php echo e($case->attorneyAmountReceived, false); ?> Rs.</label>
            </div>
        <?php endif; ?>
    </div>
    <div class="col-md-6">
        <h3><b>Case Progress</b></h3>
        <?php if(isset($case) && count($case->customerCaseDetails) > 0): ?>
            <?php $__currentLoopData = $case->customerCaseDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $count => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($details->user_type === 'customer'): ?>
                    <div class="form-group">
                        <label><?php echo e($count + 1, false); ?></label>
                        <label>Customer name:</label>
                        <label><?php echo e($details['customerDetails'] ? $details['customerDetails']->name : '', false); ?></label>
                    </div>
                <?php endif; ?>
                <?php if($details->user_type === 'attorney'): ?>
                    <div class="form-group">
                        <label><?php echo e($count + 1, false); ?></label>
                        <label>Attorney name:</label>
                        <label><?php echo e($details['customerDetails'] ? $details['customerDetails']->name : '', false); ?></label>
                    </div>
                <?php endif; ?>

                <div class="form-group">
                    <label>Message:</label>
                    <label><?php echo e($details->message, false); ?></label>
                    <br>
                    <?php if(isset($details['caseDetailImage'])): ?>
                        <a href="<?php echo e($details['caseDetailImage']['url'], false); ?>" target="_blank"><img height="30px" width="40" src="<?php echo e($details['caseDetailImage']->url, false); ?>"></a>
                    <?php endif; ?>
                </div>
                <br>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <p>No case details found</p>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/u997380332/domains/attorneyofficial.com/public_html/app/resources/views/caseDetails.blade.php ENDPATH**/ ?>