<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('user/register', 'CustomerController@register');
Route::post('user/login', 'CustomerController@login');
Route::post('user/update-password', 'CustomerController@updatePassword');
Route::get('get-settings', 'DistrictController@getCourtDetail');

Route::group(['middleware' => ['auth:api']], function() {
    Route::post('user/verify', 'CustomerController@verifyUser');
    Route::post('user/update', 'CustomerController@update');
    Route::post('case/request', 'CustomerCaseController@generateCaseRequest');
    Route::get('case/get-all-cases/{type}', 'CustomerCaseController@getAllCases');
    Route::post('case/get-case-by-id', 'CustomerCaseController@getCaseById');
    Route::post('case/get-attorney-case-by-id', 'CustomerCaseController@getCaseAssignedToAttorneyById');
    Route::get('case/attorney/get-all-cases/{type}', 'CustomerCaseController@getAllCasesByAttorney');
    Route::post('case/payment', 'CustomerCaseController@casePayment');
    Route::post('case/delivery', 'CustomerCaseController@customerWantDelivery');
    Route::post('case/delivery-receipt', 'CustomerCaseController@updateDeliveryByAttorney');
    Route::post('case/update-from-attorney', 'CustomerCaseController@attorneyUpdateCaseDetails');
    Route::post('case/update-from-attorney/attested-cases', 'CustomerCaseController@attorneyUpdateAttestedCaseDetails');
    Route::post('case/update-from-attorney/new-paper-charges', 'CustomerCaseController@attorneyUpdateNewsPaperCharges');
    Route::post('case/update-from-attorney/submit-ad-in-new-paper', 'CustomerCaseController@attorneySubmitNewsPaperAd');
    Route::post('case/attorney/completed', 'CustomerCaseController@markCaseCompletedByAttorney');
    Route::post('case/attorney/received-file', 'CustomerCaseController@attorneyReceivedFileFromCustomer');
    Route::post('case/attorney/notified', 'CustomerCaseController@notifyAttorneyForFileCase');
    Route::post('get-bank-details', 'BankController@getBankDetails');
    Route::post('update-fcm-token', 'CustomerController@updateFcmToken');
    Route::post('case-easypaisa-payment', 'CustomerCaseController@casePaymentEasyPaisa');
    Route::get('update-counter', 'CustomerController@getUpdatedCounts');

});

