<div class="row">
    <div class="col-md-6">
        <h3><b>Case Details</b></h3>
        <div class="form-group">
            <label>Customer Name:</label>
            <label>{{$case['customerDetails']->name}}</label>
        </div>
        <div class="form-group">
            <label>Attorney Name:</label>
            @if(isset($case['customerDetails']))
                <label>{{$case['customerDetails']->name}}</label>
            @endif
        </div>
        <div class="form-group">
            <label>Case Type:</label>
            <label>{{\Illuminate\Support\Facades\Config::get('constants.cases_type.' . $case->case_type)}}</label>
        </div>
        @if(isset($case->case_type))
            <div class="form-group">
                <label>Case Status:</label>
                <label>{{\Illuminate\Support\Facades\Config::get('constants.case_status.' . $case->case_type)}}</label>
            </div>
        @endif
        <div class="form-group">
            <label>Case Progress:</label>
            <label>{{$case->status}}</label>
        </div>
        @if(isset($case->court_name))
            <div class="form-group">
                <label>Court Name:</label>
                <label>{{$case->court_name}}</label>
            </div>
        @endif
        @if(isset($case->title))
            <div class="form-group">
                <label>Case Title:</label>
                <label>{{$case->title}}</label>
            </div>
        @endif
        @if(isset($case->judge_name))
            <div class="form-group">
                <label>Judge Name:</label>
                <label>{{$case->judge_name}}</label>
            </div>
        @endif
        @if(isset($case->city))
            <div class="form-group">
                <label>City: </label>
                <label>{{$case->city}}</label>
            </div>
        @endif
        @if(isset($case->case_no))
            <div class="form-group">
                <label>Case No.: </label>
                <label>{{$case->case_no}}</label>
            </div>
        @endif
        @if(isset($case->last_date_hearing))
            <div class="form-group">
                <label>Last date of Hearing:</label>
                <label>{{$case->last_date_hearing}}</label>
            </div>
        @endif
        @if(isset($case->next_hearing_date))
            <div class="form-group">
                <label>Next date of Hearing:</label>
                <label>{{$case->next_hearing_date}}</label>
            </div>
        @endif
        @if(isset($case->year))
            <div class="form-group">
                <label>Year:</label>
                <label>{{$case->year}}</label>
            </div>
        @endif
        @if(isset($case->decision_date))
            <div class="form-group">
                <label>Decision date:</label>
                <label>{{$case->decision_date}}</label>
            </div>
        @endif
        @if(isset($case->required_document))
            <div class="form-group">
                <label>Required Documents:</label>
                <label>{{$case->required_document}}</label>
            </div>
        @endif
        @if(isset($case->from_which_side_we_are))
            <div class="form-group">
                <label>From which side we are:</label>
                <label>{{$case->from_which_side_we_are}}</label>
            </div>
        @endif
        @if(isset($case->set_of_copies_required))
            <div class="form-group">
                <label>Set of copies required:</label>
                <label>{{$case->set_of_copies_required}}</label>
            </div>
        @endif
        @if(isset($case->kuliya_no))
            <div class="form-group">
                <label>Kuliya No.:</label>
                <label>{{$case->kuliya_no}}</label>
            </div>
        @endif
        @if(isset($case->parties_name))
            <div class="form-group">
                <label>Parties Name:</label>
                <label>{{$case->parties_name}}</label>
            </div>
        @endif
        @if(isset($case->news_paper_name))
            <div class="form-group">
                <label>News Paper Name:</label>
                <label>{{$case->news_paper_name}}</label>
            </div>
        @endif
        @if(isset($case->comment_for_attorney))
            <div class="form-group">
                <label>Comment for Attorney:</label>
                <label>{{$case->comment_for_attorney}}</label>
            </div>
        @endif
        @if(isset($case->amountReceived))
            <div class="form-group">
                <label>Amount Received by Admin:</label>
                <label>{{$case->amountReceived}} Rs.</label>
            </div>
        @endif
        @if(isset($case->amountReceived))
            <div class="form-group">
                <label>Attorney will get after case completion:</label>
                <label>{{$case->attorneyAmountReceived}} Rs.</label>
            </div>
        @endif
    </div>
    <div class="col-md-6">
        <h3><b>Case Progress</b></h3>
        @if(isset($case) && count($case->customerCaseDetails) > 0)
            @foreach($case->customerCaseDetails as $count => $details)
                @if($details->user_type === 'customer')
                    <div class="form-group">
                        <label>{{$count + 1}}</label>
                        <label>Customer name:</label>
                        <label>{{$details['customerDetails'] ? $details['customerDetails']->name : ''}}</label>
                    </div>
                @endif
                @if($details->user_type === 'attorney')
                    <div class="form-group">
                        <label>{{$count + 1}}</label>
                        <label>Attorney name:</label>
                        <label>{{$details['customerDetails'] ? $details['customerDetails']->name : ''}}</label>
                    </div>
                @endif

                <div class="form-group">
                    <label>Message:</label>
                    <label>{{$details->message}}</label>
                    <br>
                    @if(isset($details['caseDetailImage']))
                        <a href="{{$details['caseDetailImage']['url']}}" target="_blank"><img height="30px" width="40" src="{{$details['caseDetailImage']->url}}"></a>
                    @endif
                </div>
                <br>
            @endforeach
        @else
            <p>No case details found</p>
        @endif
    </div>
</div>
