<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCaseCostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('case_costs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('case_type');
            $table->integer('initial_pending_cost')->nullable();
            $table->string('initial_pending_message')->nullable();
            $table->integer('initial_decided_cost')->nullable();
            $table->string('initial_decided_message')->nullable();
            $table->integer('pending_service_charges')->nullable();
            $table->integer('decided_service_charges')->nullable();
            $table->integer('per_page_cost')->nullable();
            $table->integer('per_defendant_cost')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('case_costs');
    }
}
