<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterCustomerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customers', function ($table){
            $table->string('account_title')->after('account_no')->nullable();
            $table->string('bank_account_title')->after('account_title')->nullable();
            $table->string('bank_name')->after('bank_account_title')->nullable();
            $table->string('bank_account_no')->after('bank_account_title')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customers', function ($table){
            $table->dropColumn('account_title');
            $table->dropColumn('bank_account_title');
            $table->dropColumn('bank_name');
            $table->dropColumn('bank_account_no');
        });
    }
}
