<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cases', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('attorney_id')->nullable();
            $table->integer('case_type');
            $table->integer('case_status')->nullable();
            $table->string('court_name')->nullable();
            $table->string('news_paper_name')->nullable();
            $table->string('city')->nullable();
            $table->longText('title')->nullable();
            $table->string('judge_name')->nullable();
            $table->string('case_no')->nullable();
            $table->string('year')->nullable();
            $table->string('decision_date')->nullable();
            $table->string('last_date_hearing')->nullable();
            $table->string('last_hearing_date')->nullable();
            $table->string('next_hearing_date')->nullable();
            $table->longText('required_document')->nullable();
            $table->string('from_which_side_we_are')->nullable();
            $table->string('set_of_copies_required')->nullable();
            $table->string('kuliya_no')->nullable();
            $table->longText('parties_name')->nullable();
            $table->string('comment_for_attorney')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cases');
    }
}
