<?php
namespace App\Traits;

use App\Customer;
use Illuminate\Support\Facades\Config;

trait PushNotification
{
    public static function sendPushNotification($title, $body, $userId)
    {
        $SERVER_API_KEY = Config::get('constants.FIREBASE_KEY');

        $user = Customer::find($userId);
        if($user && $user->fcm_token){
            $url = 'https://fcm.googleapis.com/fcm/send';
            $dataArr = array('click_action' => 'FLUTTER_NOTIFICATION_CLICK', 'status'=>"done");
            $notification = array('title' => $title, 'body' => $body, 'image'=> '$req->img', 'sound' => 'default', 'badge' => '1',);
            $arrayToSend = array('to' => $user->fcm_token, 'notification' => $notification, 'data' => $dataArr, 'priority'=>'high');
            $fields = json_encode ($arrayToSend);
            $headers = array (
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json'
            );
            $ch = curl_init ();
            curl_setopt ( $ch, CURLOPT_URL, $url );
            curl_setopt ( $ch, CURLOPT_POST, true );
            curl_setopt ( $ch, CURLOPT_HTTPHEADER, $headers );
            curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, true );
            curl_setopt ( $ch, CURLOPT_POSTFIELDS, $fields );
            $result = curl_exec ( $ch );
//        dd($result);
            curl_close ( $ch );
        }
    }
}
