<?php

namespace App\Http\Controllers;

use App\Customer;
use App\District;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class DistrictController extends Controller
{
    use ApiResponse;

    public function getCourtDetail()
    {
        $districts = District::where('type', 1)->get();
        $districts->prepend(["id" => 1, "name" => ""]);
        $courts = District::where('type', 2)->get();
        $courts->prepend(["id" => 1, "name" => ""]);
        $data = [
            'districts' => $districts,
            'courts' => $courts
        ];
        return $this->success(200, $data, '');
    }
}
