<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Config;

class CustomerCase extends Model
{
    protected $table = 'cases';

    protected $casts = [
        'created_at' => 'date:d-m-Y H:i:s',
        'updated_at' => 'date:d-m-Y H:i:s'
    ];

    protected $fillable = [
        'customer_id', 'attorney_id', 'case_type', 'case_status', 'court_name', 'news_paper_name', 'city', 'title', 'judge_name',
        'case_no', 'year', 'decision_date', 'last_date_hearing', 'next_hearing_date', 'required_document', 'serial_no_of_defendant',
        'from_which_side_we_are', 'set_of_copies_required', 'kuliya_no', 'parties_name', 'comment_for_attorney', 'no_of_defendant',
        'admin_remarks'
    ];

    public function customerDetails(){
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function attorneyDetails(){
        return $this->belongsTo(Customer::class, 'attorney_id', 'id');
    }

    public function customerCaseDetails(){
        return $this->hasMany(CaseDetail::class, 'case_id', 'id');
    }

    public function caseImages(){
        return $this->morphMany(Image::class, 'imageable');
    }

    public function caseImage(){
        return $this->morphOne(Image::class, 'imageable');
    }

    public function initialPaymentImage(){
        return $this->morphOne(Image::class, 'imageable')->where('type', '=', 'initial_payment');
    }

    public function casePaymentImage(){
        return $this->morphOne(Image::class, 'imageable')->where('type', '=', 'case_payment');
    }

    public function caseAllImage(){
        return $this->morphMany(Image::class, 'imageable');
    }

    public function getCaseStatusAttribute($value)
    {
        return Config::get('constants.case_status.' . $value);
    }

//    public function getCaseTypeAttribute($value)
//    {
//        return Config::get('constants.cases_type.' . $value);
//    }

    public function getStatusAttribute($value)
    {
        return Config::get('constants.case_progress.' . $value);
    }

    public function getPaymentDetails(){
        return $this->hasMany(CasePayment::class, 'case_id', 'id')->where('response_desc', '=', 'SUCCESS');
    }

}
