<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Passport\HasApiTokens;

class Customer extends Authenticatable
{
    use HasApiTokens;

    protected $table = 'customers';

    protected $fillable = [
        'name', 'email', 'password', 'user_type', 'cnic', 'mobile', 'shipping_address', 'fcm_token',
        'office_address', 'courts', 'account_no', 'account_title', 'bank_account_title', 'bank_name', 'bank_account_no', 'status'
    ];
    protected $hidden = [
        'password',
    ];
    protected $casts = [
        'created_at' => 'date:d-m-Y H:i:s',
        'updated_at' => 'date:d-m-Y H:i:s'
    ];

    public function getIdCardFront(){
        return $this->morphOne(Image::class, 'imageable')->where('type', '=', 'id card front');
    }

    public function getIdCardBack(){
        return $this->morphOne(Image::class, 'imageable')->where('type', '=', 'id card back');
    }

    public function getClerkCard(){
        return $this->morphOne(Image::class, 'imageable')->where('type', '=', 'clerk card');
    }
}
