<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CaseDetail extends Model
{
    protected $table = 'case_details';

    protected $casts = [
        'created_at' => 'date:d-m-Y H:i:s',
        'updated_at' => 'date:d-m-Y H:i:s'
    ];

    protected $fillable = [
        'case_id', 'user_id', 'case_status', 'message', 'type', 'user_type', 'payment_id', 'amount'
    ];

    public function customerDetails(){
        return $this->belongsTo(Customer::class, 'user_id', 'id');
    }

    public function caseDetailImage(){
        return $this->morphOne(Image::class, 'imageable');
    }

    public function caseDetailMultipleImages(){
        return $this->morphMany(Image::class, 'imageable');
    }
}
