<?php

use Illuminate\Routing\Router;

Admin::routes();

Route::group([
    'prefix'        => config('admin.route.prefix'),
    'namespace'     => config('admin.route.namespace'),
    'middleware'    => config('admin.route.middleware'),
    'as'            => config('admin.route.prefix') . '.',
], function (Router $router) {

    $router->get('/', 'HomeController@index')->name('home');

    $router->resource('customers', CustomerController::class);
    $router->resource('attorney', AttorneyController::class);

    $router->resource('civil-cases', CivilController::class);
    $router->resource('family-cases', FamilyController::class);
    $router->resource('criminal-cases', CriminalController::class);
    $router->resource('high-court-cases', HighCourtController::class);

    $router->resource('next-hearing-cases', NextHearingController::class);
    $router->resource('interim-order-cases', InterimOrderController::class);
    $router->resource('filing-cases', FilingCaseController::class);
    $router->resource('filing-application-cases', FilingApplicationController::class);
    $router->resource('summon-notices-cases', SummonNoticesController::class);
    $router->resource('new-paper-ad-cases', NewPaperAdController::class);
    $router->resource('districts', DistrictController::class);

    $router->resource('customer-cases', CustomerCaseController::class);
    $router->resource('case-charges', CaseCostController::class);


    $router->get('get-case-images/{id}', 'SummonNoticesController@getCaseImages');
    $router->get('get-case-details/{id}', 'CivilController@getCaseDetails');
    $router->get('edit-case-charges/{id}', 'CaseCostController@getCaseCharges');
    $router->post('update-case-charges', 'CaseCostController@updateCaseCharges');

});
