<?php

namespace App\Admin\Controllers;

use App\Customer;
use App\CustomerCase;
use App\Traits\PushNotification;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Layout\Content;
use Encore\Admin\Show;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;

class InterimOrderController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Interim Order/Last Order of Court';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new CustomerCase());

        $grid->disableCreateButton();
        $grid->disableFilter();
        $grid->disableBatchActions(true);
        $grid->actions(function ($actions) {
            $actions->disableDelete();
            $actions->disableView();
        });

        $grid->model()->where('case_type', '=', 6);
        $grid->model()->orderBy('id', 'desc');

        $grid->id('Id')->display(function ($id) {
            return '<div style="width: 130px">'.$id. '<br> <a href="get-case-details/'.$id.'"><i class="fa fa-eye"> Case Details</i></a>'
                . ' <a href="interim-order-cases/'.$id.'/edit"><i class="fa fa-edit"> Assign Attorney</i></a></div>';
        });
        $grid->column('customerDetails.name', __('Customer Name'));
        $grid->column('attorneyDetails.name', 'Attorney Name')->display(function ($attorney) {
            if ($attorney) {
                return $attorney;
            } else {
                return 'Attorney not assigned';
            }
        });
        $grid->column('title', __('Title'));
        $grid->column('judge_name', __('Judge name'));
        $grid->column('last_date_hearing', __('Last date hearing'));
        $grid->column('comment_for_attorney', __('Comment for attorney'));
        $grid->column('court_name', __('City'));
        $grid->column('status', __('Case Status'));
        $grid->column('created_at', __('Generated Date'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(CustomerCase::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('customer_id', __('Customer id'));
        $show->field('attorney_id', __('Attorney id'));
        $show->field('case_type', __('Case type'));
        $show->field('case_status', __('Case status'));
        $show->field('court_name', __('Court name'));
        $show->field('news_paper_name', __('News paper name'));
        $show->field('city', __('City'));
        $show->field('title', __('Title'));
        $show->field('judge_name', __('Judge name'));
        $show->field('case_no', __('Case no'));
        $show->field('year', __('Year'));
        $show->field('decision_date', __('Decision date'));
        $show->field('last_date_hearing', __('Last date hearing'));
        $show->field('last_hearing_date', __('Last hearing date'));
        $show->field('next_hearing_date', __('Next hearing date'));
        $show->field('required_document', __('Required document'));
        $show->field('from_which_side_we_are', __('From which side we are'));
        $show->field('set_of_copies_required', __('Set of copies required'));
        $show->field('kuliya_no', __('Kuliya no'));
        $show->field('parties_name', __('Parties name'));
        $show->field('comment_for_attorney', __('Comment for attorney'));
        $show->field('status', __('Status'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new CustomerCase());

        $form->tools(function (Form\Tools $tools) {
            $tools->disableDelete();
            $tools->disableView();
            $tools->disableList();
        });
        $attorneies = Customer::where(['user_type' => 'attorney'])->pluck('name', 'id');
        $form->select('attorney_id', __('Attorney Name'))->options($attorneies);
        $form->ignore('case_type', __('Case type'));
        $form->ignore('case_status', __('Case status'));
        $form->ignore('court_name', __('Court name'));
        $form->ignore('news_paper_name', __('News paper name'));
        $form->ignore('city', __('City'));
        $form->ignore('title', __('Title'));
        $form->ignore('judge_name', __('Judge name'));
        $form->ignore('case_no', __('Case no'));
        $form->ignore('year', __('Year'));
        $form->ignore('decision_date', __('Decision date'));
        $form->ignore('last_date_hearing', __('Last date hearing'));
        $form->ignore('last_hearing_date', __('Last hearing date'));
        $form->ignore('next_hearing_date', __('Next hearing date'));
        $form->ignore('required_document', __('Required document'));
        $form->ignore('from_which_side_we_are', __('From which side we are'));
        $form->ignore('set_of_copies_required', __('Set of copies required'));
        $form->ignore('kuliya_no', __('Kuliya no'));
        $form->ignore('parties_name', __('Parties name'));
        $form->ignore('comment_for_attorney', __('Comment for attorney'));
        $form->ignore('status', __('Status'));

        $form->saved(function (Form $form) {
            $id = $form->model()->id;
            DB::table('cases')->where('id', $id)->update(['status' => 2]);
            $case = CustomerCase::where('id', $id)->first();
            PushNotification::sendPushNotification(
                Config::get('constants.push_notification_assign_attorney_title'),
                Config::get('constants.push_notification_assign_attorney_body'),
                $case->attorney_id
            );
            PushNotification::sendPushNotification(
                Config::get('constants.push_notification_customer_update_title'),
                Config::get('constants.push_notification_customer_attorney_update'),
                $case->customer_id
            );
        });

        $form->footer(function ($footer) {
            $footer->disableViewCheck();
            $footer->disableEditingCheck();
            $footer->disableCreatingCheck();
        });
        return $form;
    }

    public function getCaseDetails($id){
        $case = CustomerCase::with('customerCaseDetails', 'customerCaseDetails.caseDetailImage', 'customerCaseDetails.customerDetails',
            'caseAllImage', 'customerDetails', 'attorneyDetails', 'initialPaymentImage', 'casePaymentImage')
            ->where('id', $id)->first();
        $content = new Content();
        $content->body(view('caseDetails')->with(['case' => $case]));

        return $content;
    }
}
