<?php

namespace App\Admin\Controllers;

use App\CaseDetail;
use App\Customer;
use App\CustomerCase;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Encore\Admin\Controllers\Dashboard;
use Encore\Admin\Layout\Column;
use Encore\Admin\Layout\Content;
use Encore\Admin\Layout\Row;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    public function index(Content $content)
    {
        return $content
            ->title('Dashboard')

            ->row(function (Row $row) {


                $lastWeekCaseDetails = CustomerCase::where('created_at', '>', Carbon::now()->subDays(7))->count();
                $row->column(4, function (Column $column) use ($lastWeekCaseDetails) {
                    $column->append('
                      <!-- small box -->
                      <div class="small-box bg-blue-gradient">
                        <div class="inner">
                          <h3>Total Cases</h3>

                          <p>Total Cases <b>'.  $lastWeekCaseDetails .'</b></p>
                        </div>
                        <div class="icon">
                        <a href="/admin/customer-cases">'.  $lastWeekCaseDetails .'</a>
                        </div>
                        <a class="small-box-footer"></a>
                      </div>
                    ');
                });

                $pendingcases = CustomerCase::where('status', '=', 1)->count();
                $row->column(4, function (Column $column) use ($pendingcases) {
                    $column->append('
                      <!-- small box -->
                      <div class="small-box bg-blue-gradient">
                        <div class="inner">
                          <h3>Pending Cases</h3>

                          <p>Pending Cases <b>'.  $pendingcases .'</b></p>
                        </div>
                        <div class="icon">
                        <a href="/admin/customer-cases?status=1">'.  $pendingcases .'</a>
                        </div>
                        <a class="small-box-footer"></a>
                      </div>
                    ');
                });

                $caseInProgress = CustomerCase::where('status', '!=', 3)->count();
                $row->column(4, function (Column $column) use ($caseInProgress) {
                    $column->append('
                      <!-- small box -->
                      <div class="small-box bg-blue-gradient">
                        <div class="inner">
                          <h3>InProgress Cases</h3>

                          <p>Total Cases <b>'.  $caseInProgress .'</b></p>
                        </div>
                        <div class="icon">
                        <a href="/admin/customer-cases?status=2">'.  $caseInProgress .'</a>
                        </div>
                        <a class="small-box-footer"></a>
                      </div>
                    ');
                });

                $caseCompleted = CustomerCase::where('status', '=', 3)->count();
                $row->column(4, function (Column $column) use ($caseCompleted) {
                    $column->append('
                      <!-- small box -->
                      <div class="small-box bg-blue-gradient">
                        <div class="inner">
                          <h3>Complete Cases</h3>

                          <p>Total Cases <b>'.  $caseCompleted .'</b></p>
                        </div>
                        <div class="icon">
                          <a href="/admin/customer-cases?status=3">'.  $caseCompleted .'</a>
                        </div>
                        <a class="small-box-footer"></a>
                      </div>
                    ');
                });

                $caseAdminCompleted = CustomerCase::where('status', '=', 4)->count();
                $row->column(4, function (Column $column) use ($caseAdminCompleted) {
                        $column->append('
                      <!-- small box -->
                      <div class="small-box bg-blue-gradient">
                        <div class="inner">
                          <h3>Admin Completed</h3>
                          <p>Total Cases <b>'. $caseAdminCompleted .'</b></p>
                        </div>
                        <div class="icon">
                        <a href="/admin/customer-cases?status=4">'.  $caseAdminCompleted .'</a>
                        </div>
                        <a class="small-box-footer"></a>
                      </div>
                    ');
                    });


                $caseCounts = CustomerCase::groupBy('case_type')->select('case_type', DB::raw('count(*) as total'))->get();
                foreach ($caseCounts as $key => $case)
                {
                    $row->column(4, function (Column $column) use ($case) {
                        $column->append('
                      <!-- small box -->
                      <div class="small-box bg-blue-gradient">
                        <div class="inner">
                          <h4>'. Config::get('constants.cases_type.' . $case->case_type).'</h4>

                          <p>Total Cases <b>'.  $case->total .'</b></p>
                        </div>
                        <div class="icon">
                          '.  $case->total .'
                        </div>
                        <a class="small-box-footer"></a>
                      </div>
                    ');
                    });
                }
            });
    }
}
