<?php

namespace App\Admin\Controllers;

use App\District;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Illuminate\Support\Facades\Config;

class DistrictController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'District';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new District());

        $grid->filter(function($filter) {
            $filter->disableIdFilter();
            $filter->like('name', __('Name'));
            $filter->like('type', __('Type'))->select(Config::get('constants.DISTRICT_TYPES'));
        });

        $grid->column('id', __('Id'));
        $grid->column('type', 'Type')->display(function ($type) {
            return Config::get('constants.DISTRICT_TYPES.'. $type);
        });
        $grid->column('name', __('Name'));
        $grid->column('office_mobile', __('Office Mobile'));
        $grid->column('address', __('Address'));
        $grid->column('created_at', __('Created at'));
        $grid->column('updated_at', __('Updated at'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(District::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('type', __('Type'));
        $show->field('name', __('Name'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new District());

        $form->radio('type', __('Type'))->options(Config::get('constants.DISTRICT_TYPES'))->default('1');
        $form->text('name', __('Name'))->rules('required');
        $form->text('address',   __('Address'));
        $form->mobile('office_mobile',   __('Office Mobile'));

        return $form;
    }
}
