<?php

namespace App\Admin\Controllers;

use App\CustomerCase;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Illuminate\Support\Facades\Config;

class CustomerCaseController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Customer Cases';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new CustomerCase());
        $grid->model()->orderBy('id', 'desc');
        $grid->disableCreateButton();
        $grid->disableBatchActions(true);
        $grid->disableActions();
        $grid->actions(function ($actions) {
            $actions->disableDelete();
            $actions->disableView();
        });
        $grid->filter(function($filter) {
            $filter->disableIdFilter();
            $filter->equal('id', __('Case No.'));
            $filter->like('customerDetails.name', __('Customer Name'));
            $filter->like('attorneyDetails.name', __('Attorney Name'));
            $filter->like('court_name', __('Court Name'));
            $filter->like('case_type', __('Case type'))->select(Config::get('constants.cases_type'));
            $filter->like('status', __('Case Status'))->select(Config::get('constants.case_progress'));
        });


        $grid->id('Id')->display(function ($id) {
            return '<div style="width: 130px">'.$id. '<br> <a href="get-case-details/'.$id.'"><i class="fa fa-eye"> Case Details</i></a>'
                . ' <a href="civil-cases/'.$id.'/edit"><i class="fa fa-edit"> Assign Attorney</i></a></div>';
        });
        $grid->column('customerDetails.name', __('Customer Name'));
        $grid->column('attorneyDetails.name', 'Attorney Name')->display(function ($attorney) {
            if ($attorney) {
                return $attorney;
            } else {
                return 'Attorney not assigned';
            }
        });
        $grid->column('case_type', 'Case type')->display(function ($caseType) {
            return Config::get('constants.cases_type.'. $caseType);
        });

        $grid->column('case_status', __('Case status'));
        $grid->column('court_name', __('Court Name'));
        $grid->column('title', __('Title'));
        $grid->status('Status')->editable('select', [4 => 'Admin Completed']);


        $grid->admin_remarks( __('Admin Remarks'))->editable('textarea');

        $grid->column('created_at', __('Created at'));
        $grid->column('updated_at', __('Updated at'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(CustomerCase::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('customer_id', __('Customer id'));
        $show->field('attorney_id', __('Attorney id'));
        $show->field('case_type', __('Case type'));
        $show->field('case_status', __('Case status'));
        $show->field('court_name', __('Court name'));
        $show->field('news_paper_name', __('News paper name'));
        $show->field('city', __('City'));
        $show->field('title', __('Title'));
        $show->field('judge_name', __('Judge name'));
        $show->field('case_no', __('Case no'));
        $show->field('year', __('Year'));
        $show->field('decision_date', __('Decision date'));
        $show->field('last_date_hearing', __('Last date hearing'));
        $show->field('last_hearing_date', __('Last hearing date'));
        $show->field('next_hearing_date', __('Next hearing date'));
        $show->field('required_document', __('Required document'));
        $show->field('from_which_side_we_are', __('From which side we are'));
        $show->field('set_of_copies_required', __('Set of copies required'));
        $show->field('kuliya_no', __('Kuliya no'));
        $show->field('serial_no_of_defendant', __('Serial no of defendant'));
        $show->field('parties_name', __('Parties name'));
        $show->field('no_of_defendant', __('No of defendant'));
        $show->field('comment_for_attorney', __('Comment for attorney'));
        $show->field('status', __('Status'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new CustomerCase());

        $form->number('customer_id', __('Customer id'));
        $form->number('attorney_id', __('Attorney id'));
        $form->number('case_type', __('Case type'));
        $form->number('case_status', __('Case status'));
        $form->text('court_name', __('Court name'));
        $form->text('news_paper_name', __('News paper name'));
        $form->text('city', __('City'));
        $form->textarea('title', __('Title'));
        $form->text('judge_name', __('Judge name'));
        $form->text('case_no', __('Case no'));
        $form->text('year', __('Year'));
        $form->text('decision_date', __('Decision date'));
        $form->text('last_date_hearing', __('Last date hearing'));
        $form->text('last_hearing_date', __('Last hearing date'));
        $form->text('next_hearing_date', __('Next hearing date'));
        $form->textarea('required_document', __('Required document'));
        $form->textarea('admin_remarks', __('admin_remarks'));
        $form->text('from_which_side_we_are', __('From which side we are'));
        $form->text('set_of_copies_required', __('Set of copies required'));
        $form->text('kuliya_no', __('Kuliya no'));
        $form->text('serial_no_of_defendant', __('Serial no of defendant'));
        $form->textarea('parties_name', __('Parties name'));
        $form->number('no_of_defendant', __('No of defendant'));
        $form->text('comment_for_attorney', __('Comment for attorney'));
        $form->select('status', 'Status')->options(Config::get('constants.case_progress'));

        return $form;
    }
}
