<?php

namespace App\Admin\Controllers;

use App\CaseCost;
use Encore\Admin\Admin;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Layout\Content;
use Encore\Admin\Show;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\URL;

class CaseCostController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Case Costs';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new CaseCost());

//        $grid->disableCreateButton();

        $grid->disableCreateButton();
        $grid->disableFilter();
        $grid->disableBatchActions(true);
        $grid->disableActions(true);

        $caseType = 0;
        $grid->column('id', 'Id');

        $grid->column('case_type', 'Case Type')->display(function ($type) {
            return '<div style="width: 130px"><br> <a href="edit-case-charges/'.$type.'"><i class="fa fa-edit">'. Config::get('constants.cases_type.'. $type) . '</i></a></div>';
        });
        $grid->column('initial_pending_cost', __('Initial Pending Charges'));
        $grid->column('initial_pending_message', __('Initial Pending Msg'));
        $grid->column('initial_decided_cost', __('Initial Decided Charges'));
        $grid->column('initial_decided_message', __('Initial Decided Msg'));
        $grid->column('pending_service_charges', __('Pending Service Charges'));
        $grid->column('decided_service_charges', __('Decided Service Charges'));
        $grid->column('per_page_cost', __('Per Page Cost'));
        $grid->column('per_defendant_cost', __('Per Defendant Charges'));

//        $grid->column('created_at', __('Created at'));
//        $grid->column('updated_at', __('Updated at'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(CaseCost::findOrFail($id));
        $show->panel()->tools(function ($tools) {
            $tools->disableDelete();
            $tools->disableEdit();
        });

        $show->field('id', __('Id'));
        $show->field('case_type', __('Case type'));
        $show->field('initial_cost', __('Initial cost'));
        $show->field('initial_msg', __('Initial msg'));
        $show->field('per_page_cost', __('Per page cost'));
        $show->field('delivery_msg', __('Delivery msg'));
        $show->field('courier_msg', __('Courier msg'));
        $show->field('case_complete_msg', __('Case complete msg'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));



        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new CaseCost());
//        if(Route::current()->action['as'] === 'admin.case-charges.edit'){
            $caseType = Route::current()->parameter('case_charge');
            $caseCosts = CaseCost::where('case_type', $caseType)->first();
            Admin::js(asset('case/caseCharges.js'));
            return view('caseCosts')->with(['cases' => Config::get('constants.cases_type'), 'caseCharges' => $caseCosts]);
//        }


//        $form->tools(function (Form\Tools $tools) {
//
//            // Disable `List` btn.
//            $tools->disableList();
//
//            // Disable `Delete` btn.
//            $tools->disableDelete();
//        });
//
//
//        $form->select('case_type', __('Case Type'))->options(Config::get('constants.cases_type'))->rules('required');
//        $form->number('initial_cost', __('Initial Cost'));
//        $form->number('service_charges', __('Service Charges'));
//        $form->textarea('initial_msg', __('Initial Message'));
//        $form->textarea('attorney_initial_msg', __('Attorney Initial Message'));
//        $form->number('per_page_cost', __('Per Page Cost'));
//        $form->number('delivery_charges', __('Delivery Charges'));
//        $form->textarea('delivery_msg', __('Delivery Message'));
//        $form->textarea('courier_msg', __('Courier Message'));
//        $form->textarea('case_complete_msg', __('Case complete Message'));
//
//        $form->footer(function ($footer) {
//            $footer->disableViewCheck();
//            $footer->disableEditingCheck();
//            $footer->disableCreatingCheck();
//        });
        return $form;
    }

    public function getCaseCharges($id)
    {
        Artisan::call('config:clear');
        Artisan::call('cache:clear');
        Artisan::call('route:clear');
        $caseCosts = CaseCost::where('case_type', $id)->first();
        Admin::js(asset('case/caseCharges.js'));
        $content = new Content();
        $content->body(view('caseCosts')->with(['caseName' => Config::get('constants.cases_type.'. $id), 'caseCharges' => $caseCosts]));

        return $content;
    }

    public function updateCaseCharges(Request $request){
        $caseCostDetails = CaseCost::where('case_type', $request->case_type)->first();
        $data = $request->except(['_token', 'case_type']);
        $caseCostDetails->update($data);

        return redirect()->to('admin/case-charges');
    }
}
