<?php

namespace App\Admin\Controllers;

use App\Customer;
use Encore\Admin\Controllers\AdminController;
use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;

class AttorneyController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Attorney';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Customer());

        $grid->model()->where('user_type', '=', 'attorney');
        $grid->model()->orderBy('id', 'desc');

        $grid->disableCreateButton();
        $grid->disableFilter();
        $grid->disableBatchActions(true);
        $grid->disableActions(true);

        $grid->column('id', __('Id'));
        $grid->column('name', __('Name'));
        $grid->column('email', __('Email'));
        $grid->column('cnic', __('Cnic'));
        $grid->column('mobile', __('Mobile'));

        $grid->column('getIdCardFront.url', 'Id Card Front')->display(function ($imageUrl){
            if($imageUrl){
                $str = explode("/", $imageUrl);
                $str[3] = "public";
                $updatedUrl = implode("/", $str);
                return $updatedUrl;
            }
            else{
                return '';
            }
        })
            ->lightbox(['width' => 50, 'height' => 50, 'zooming' => true])->width(150);
        $grid->column('getIdCardBack.url', 'Id Card Back')->display(function ($imageUrl){
            if($imageUrl){
                $str = explode("/", $imageUrl);
                $str[3] = "public";
                $updatedUrl = implode("/", $str);
                return $updatedUrl;
            }
            else{
                return '';
            }
        })
            ->lightbox(['width' => 50, 'height' => 50, 'zooming' => true])->width(150);
        $grid->column('getClerkCard.url', 'Clerk Card')->display(function ($imageUrl){
            if($imageUrl){
                $str = explode("/", $imageUrl);
                $str[3] = "public";
                $updatedUrl = implode("/", $str);
                return $updatedUrl;
            }
            else{
                return '';
            }
        })
            ->lightbox(['width' => 50, 'height' => 50, 'zooming' => true])->width(150);


        $grid->column('shipping_address', __('Shipping address'));
        $grid->column('office_address', __('Office address'));
        $grid->column('courts', __('Courts'));
        $grid->column('account_title', __('Account Title'));
        $grid->column('account_no', __('Account No.'));
        $grid->column('bank_account_title', __('Bank Account Title'));
        $grid->column('bank_account_no', __('Bank Account No.'));
        $grid->column('bank_name', __('Bank Name'));
        $grid->status('Is Verified')->editable('select',  [
            1 => Config::get('constants.attorney_status.1'),
            2 => Config::get('constants.attorney_status.2'),
            ] );
        $grid->column('created_at', __('Created at'));
        $grid->column('updated_at', __('Updated at'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Customer::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('name', __('Name'));
        $show->field('email', __('Email'));
        $show->field('cnic', __('Cnic'));
        $show->field('mobile', __('Mobile'));
        $show->field('shipping_address', __('Shipping address'));
        $show->field('office_address', __('Office address'));
        $show->field('courts', __('Courts'));
        $show->field('account_no', __('Account no'));
        $show->status('Is Verified')->as(function ($status) {
            if ($status) {
                $data = Config::get('constants.attorney_status.' . $status);
                return $data;
            } else {
                return '';
            }
        });
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Customer());

        $form->text('name', __('Name'));
        $form->text('user_type', __('User type'));
        $form->email('email', __('Email'));
        $form->password('password', __('Password'));
        $form->text('cnic', __('Cnic'));
        $form->mobile('mobile', __('Mobile'));
        $form->textarea('shipping_address', __('Shipping address'));
        $form->textarea('office_address', __('Office address'));
        $form->text('courts', __('Courts'));
        $form->text('account_no', __('Account no'));
        $form->text('fcm_token', __('Fcm token'));
        $form->switch('status', __('Status'))->default(1);

        return $form;
    }
}
